function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Competitive.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(33, 1);
lhs = exp(y(35));
rhs = T(7)^(params(2)/(params(2)-1));
residual(1) = lhs - rhs;
lhs = exp(y(18));
rhs = params(11)*T(8)*T(10);
residual(2) = lhs - rhs;
lhs = exp(y(40));
rhs = T(3)*T(8)*T(2)*(1-params(11))*(1-params(3))*T(11)*T(12);
residual(3) = lhs - rhs;
lhs = exp(y(39));
rhs = T(4)*T(11)*T(8)*T(2)*(1-params(11))*params(3)*T(13);
residual(4) = lhs - rhs;
lhs = exp(y(29));
rhs = T(2)*exp(y(13)*params(3))*exp(y(37)*(1-params(3)));
residual(5) = lhs - rhs;
lhs = exp(y(38))+exp(y(36))+exp(y(20))+exp(y(19))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(6)*exp(params(5)*(y(10)-y(43)))*exp(y(6));
rhs = exp(y(35))+exp(y(13))*(1-params(10));
residual(6) = lhs - rhs;
lhs = exp(y(37));
rhs = T(14)*exp(y(40))^(1/params(8));
residual(7) = lhs - rhs;
lhs = 1;
rhs = T(15)*(1+exp(y(56))-params(10));
residual(8) = lhs - rhs;
lhs = exp(y(41));
rhs = T(17)/T(19);
residual(9) = lhs - rhs;
lhs = y(30);
rhs = T(15)*(exp(y(28))*exp(y(51))+(1-exp(y(28)))*y(52)-params(6)*exp(params(5)*y(28)));
residual(10) = lhs - rhs;
lhs = y(31);
rhs = y(30)*params(7)+T(15)*(1-params(7))*y(53);
residual(11) = lhs - rhs;
lhs = y(31)*params(4)*exp(y(20)*(params(4)-1))*T(20);
rhs = 1;
residual(12) = lhs - rhs;
lhs = T(15)*params(6)*params(5)*exp(y(28)*(params(5)-1));
rhs = T(15)*(exp(y(51))-y(52));
residual(13) = lhs - rhs;
lhs = y(33);
rhs = T(21);
residual(14) = lhs - rhs;
lhs = y(34);
rhs = params(7)*y(33)+T(15)*(1-params(7))*y(55);
residual(15) = lhs - rhs;
lhs = y(34)*params(4)*exp(y(19)*(params(4)-1))*T(22);
rhs = 1;
residual(16) = lhs - rhs;
lhs = T(15)*params(6)*params(5)*exp((params(5)-1)*y(27))*exp(y(58)*(-params(5)));
rhs = T(15)*exp((-y(58)))*(exp(y(51))-y(54));
residual(17) = lhs - rhs;
lhs = exp(y(24));
rhs = exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(26));
residual(18) = lhs - rhs;
lhs = exp(y(23));
rhs = exp(y(6))*(1-exp((-y(43)))*exp(y(10)))+params(7)*exp(y(25));
residual(19) = lhs - rhs;
lhs = exp(y(26));
rhs = (1-params(7))*exp(y(9))+T(20)*exp(y(20)*params(4));
residual(20) = lhs - rhs;
lhs = exp(y(25));
rhs = (1-params(7))*exp(y(8))+T(22)*exp(y(19)*params(4));
residual(21) = lhs - rhs;
lhs = exp(y(22));
rhs = exp(y(7))*exp(y(11));
residual(22) = lhs - rhs;
lhs = exp(y(21));
rhs = exp(y(6))*exp((-y(43)))*exp(y(10));
residual(23) = lhs - rhs;
lhs = exp(y(32));
rhs = exp(y(22))+exp(y(21));
residual(24) = lhs - rhs;
lhs = y(43);
rhs = x(it_, 1);
residual(25) = lhs - rhs;
lhs = y(42);
rhs = x(it_, 2)+params(15)*y(16)+params(16)*y(17);
residual(26) = lhs - rhs;
lhs = y(44);
rhs = y(18)-y(1);
residual(27) = lhs - rhs;
lhs = y(45);
rhs = y(20)-y(3);
residual(28) = lhs - rhs;
lhs = y(46);
rhs = y(19)-y(2);
residual(29) = lhs - rhs;
lhs = y(47);
rhs = y(22)-y(5);
residual(30) = lhs - rhs;
lhs = y(48);
rhs = y(21)-y(4);
residual(31) = lhs - rhs;
lhs = y(49);
rhs = y(35)-y(12);
residual(32) = lhs - rhs;
lhs = y(50);
rhs = y(16);
residual(33) = lhs - rhs;

end
